/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.RequestFlowMainTableRow;
import cz.insophy.inplan.report.result.RequestFlowResult;
import cz.insophy.inplan.report.result.RequestFlowSumTableRow;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;

public class RequestFlowComputer
extends AbstractReportComputer<RequestFlowResult> {
    private GeneralizedOrderRequest gor = null;

    public void setActiveGor(GeneralizedOrderRequest gor) {
        this.gor = gor;
    }

    @Override
    public RequestFlowResult compute(Superplan superplan) {
        if (this.gor == null) {
            return null;
        }
        ArrayList<RequestFlowMainTableRow> mainTableRows = new ArrayList<RequestFlowMainTableRow>();
        long sumProduction = 0L;
        long sumLogistic = 0L;
        long sumWaiting = 0L;
        GeneralizedActionRequest prevGar = null;
        for (GeneralizedActionRequest gar : this.gor.getGars()) {
            RequestFlowMainTableRow row = new RequestFlowMainTableRow(mainTableRows.size() + 1, this.gor, gar, prevGar);
            if (!row.isPlanned()) continue;
            mainTableRows.add(row);
            prevGar = gar;
            sumProduction += row.getProductionTime();
            sumLogistic += row.getLogisticTime();
            sumWaiting += row.getWaitingTime();
        }
        if (mainTableRows.isEmpty()) {
            return null;
        }
        long gorDelay = ReportUtilities.getGorDelay(this.gor);
        long endDateWindow = ReportUtilities.getEndDateWindowSize(this.gor);
        long dueDateWindow = ReportUtilities.getDueDateWindowSize(this.gor);
        ArrayList<RequestFlowSumTableRow> sumTableRows = new ArrayList<RequestFlowSumTableRow>();
        if (!mainTableRows.isEmpty()) {
            sumTableRows.add(new RequestFlowSumTableRow(Localizer.getString("report.request_flow.production"), sumProduction, endDateWindow, dueDateWindow));
            sumTableRows.add(new RequestFlowSumTableRow(Localizer.getString("report.request_flow.logistics"), sumLogistic, endDateWindow, dueDateWindow));
            sumTableRows.add(new RequestFlowSumTableRow(Localizer.getString("report.request_flow.waiting"), sumWaiting, endDateWindow, dueDateWindow));
        }
        boolean crossed = false;
        if (this.gor.getReleaseDate() >= this.gor.getDueDate()) {
            crossed = true;
        }
        String infoLabel = RequestFlowComputer.formatInfoLabel(this.gor.getId(), this.gor.getReleaseDate(), this.gor.getDueDate(), this.gor.getStartDate(), this.gor.getEndDate(), dueDateWindow, endDateWindow);
        String statusLabel = RequestFlowComputer.formatStatusLabel(gorDelay, endDateWindow, crossed);
        boolean isDelayed = gorDelay > 0L;
        return new RequestFlowResult(Collections.unmodifiableList(mainTableRows), Collections.unmodifiableList(sumTableRows), infoLabel, statusLabel, isDelayed);
    }

    private static String formatInfoLabel(String gor, long releaseDate, long dueDate, long startDate, long endDate, long dueDateWindow, long endDateWindow) {
        return String.format("<html>" + Localizer.getString("report.request_flow.gor.info") + "</html>", gor, Formatter.formatMediumDateTime(releaseDate), Formatter.formatMediumDateTime(dueDate), Formatter.formatDurationDay(dueDateWindow), Formatter.formatMediumDateTime(startDate), Formatter.formatMediumDateTime(endDate), Formatter.formatDurationDay(endDateWindow));
    }

    private static String formatStatusLabel(long delay, double window, boolean crossed) {
        if (crossed) {
            return Localizer.getString("report.request_flow.gor.crossed");
        }
        double ratio = window == 0.0 ? 0.0 : (double)delay / window;
        return String.format("<html>" + Localizer.getString(delay > 0L ? "report.request_flow.gor.bad" : "report.request_flow.gor.good") + "</html>", Formatter.formatDurationDay(Math.abs(delay)), Math.abs(ratio * 100.0));
    }
}

